#include<iostream>
#include<vector>
#include<cmath>
#include<set>

class Point
{
    public:
    int x;
    int y;
    int id;

    double distance()
    {
        return sqrt((x*x) + (y*y));
    }

    static void Sort(std::vector<Point>& v)
    {
        for(int i = 0; i < v.size() - 1; i++)
        {
            bool swapped = false;

            for(int j = 0; j < v.size() - i - 1; j++)
            {
                if(v[j].distance() < v[j + 1].distance())
                {
                    Point a = v[j];
                    v[j] = v[j + 1];
                    v[j + 1] = a;
                    swapped = true;
                }
            }

            if(!swapped) break;
        }
    }
};

int main()
{
    int n;
    std::vector<Point> points;
    std::cin >> n;

    for(int i = 0; i < n; i++)
    {
        Point a;
        std::cin >> a.x;
        std::cin >> a.y;
        a.id = i + 1;
        points.push_back(a);
    }

    Point::Sort(points);

    std::set<int> results;

    results.insert(points[0].id);

    Point a = points[0];

    std::cout << "0: " << a.x << " " << a.y << " " << points[0].id <<"\n";
    
    for(int i = 1; i < points.size() - 1; i++)
    {
        a.x += points[i].x; 
        a.y += points[i].y;

        std::cout << i << ": " << a.x << " " << a.y << " " << points[i].id <<"\n";

        if(a.distance() > points[i - 1].distance())
        {
            results.insert(points[i].id);
        }

        else
        {
            a.x -= points[i].x;
            a.y -= points[i].y;
        }
    }

    std::cout << results.size() << "\n";

    for(int num : results)
    {
        std::cout << num << " ";
    }

    return 0;
}